/*
  LuxTag Volume.js
  
  
*/

// global variables.
var version_num = "0.1";

var volume_types = ["exponential","homogenous","cloud"];

function buildUI( tag ) {
	
	tag.addParameterSeparator("[ Volume ]");
	tag.addParameterSelector("volume type", volume_types, false, false);
	
	tag.addParameterSeparator("common option");
	
	// sigma_a
	tag.addParameterFloat("absorption R",1,0,1,false,false);
	tag.addParameterFloat("absorption G",1,0,1,false,false);
	tag.addParameterFloat("absorption B",1,0,1,false,false);
	// sigma_s
	tag.addParameterFloat("scattering R",0,0,1,false,false);
	tag.addParameterFloat("scattering G",0,0,1,false,false);
	tag.addParameterFloat("scattering B",0,0,1,false,false);
	// Le
	tag.addParameterFloat("emission R",0,0,1,false,false);
	tag.addParameterFloat("emission G",0,0,1,false,false);
	tag.addParameterFloat("emission B",0,0,1,false,false);
	// g
	tag.addParameterFloat("asymmetry g", 0, 0, 100, false, false);
	
	tag.addParameterSeparator("exponential option");
	tag.addParameterFloat("form a/scale", 1.0, 0.0, 100.0, false, false);
	tag.addParameterFloat("form b/falloff", 2.0, 0.0, 100.0, false, false);
	tag.addParameterFloat("updir x", 0.0, 0.0, 1.0, false, false);
	tag.addParameterFloat("updir y", 1.0, 0.0, 1.0, false, false);
	tag.addParameterFloat("updir z", 0.0, 0.0, 1.0, false, false);
	
	tag.addParameterSeparator("cloud option");
	tag.addParameterFloat("radius", 0.5, 0.01, 2.0, false, false);
	tag.addParameterFloat("noisescale", 0.3, 0.1, 1.0, false, false);
	tag.addParameterFloat("turbulence", 0.5, 0.0, 3.0, false, false);
	tag.addParameterFloat("noiseoffset", 0.0, 0.0, 1000.0, false, false);
	tag.addParameterInt("octaves", 3, 1, 8, false, false);
	tag.addParameterFloat("omega", 0.75, 0.1, 1.0, false, false);
	tag.addParameterFloat("sharpness", 6.0, 0.2, 10.0, false, false);
	tag.addParameterFloat("variability", 0.9, 0.0, 1.0, false, false);
	tag.addParameterFloat("baseflatness", 0.8, 0.0, 1.0, false, false);
	tag.addParameterInt("spheres", 2000, 0, 10000, false, false);
	tag.addParameterFloat("spheresize", 0.15, 0.05, 0.55, false, false);

}
